package w83b.w83bDAO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bBeans.W83bHistoricosBean;
import w83b.w83bDAO.w83bConstantesBD.W83bHistoricosBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;

public class W83bHistoricosDAO implements W83bIHistoricosDAO{

	public List w83bCargaCuadroResumenHist (W83bHistoricosBean param)throws Exception{
		List resultado = new ArrayList();
		
		List params = new ArrayList();
		
		if(this.hayRegistros(param)){
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);		
			//Sin porcentaje (se saca cada lnea con su porcentaje)
		
				
				strSql.append("SELECT NVL(SUM(");		
				strSql.append(W83bHistoricosBD.T_EMPRH49_078).append("+");
				strSql.append(W83bHistoricosBD.T_EMPRM49_078).append("),0) AS NUMEMPRESAS, NVL(SUM(");
				strSql.append(W83bHistoricosBD.T_ELECHH49_078).append("+").append(W83bHistoricosBD.T_ELECHM49_078).append("+");
				strSql.append(W83bHistoricosBD.T_ELECMH49_078).append("+").append(W83bHistoricosBD.T_ELECMM49_078).append("+");
				strSql.append(W83bHistoricosBD.T_ELECNH49_078).append("+").append(W83bHistoricosBD.T_ELECNM49_078).append("),0) AS TOTELECTORES, NVL(SUM(");
				strSql.append(W83bHistoricosBD.T_VOTAH49_078).append("+").append(W83bHistoricosBD.T_VOTAM49_078).append("),0) AS TOTVOTANTES, NVL(SUM(");
				strSql.append(W83bHistoricosBD.T_CENTH49_078).append("+").append(W83bHistoricosBD.T_CENTM49_078).append("),0) AS TOTCENTROS ");
				strSql.append(" FROM ").append(W83bHistoricosBD.tabla78).append(" WHERE ");
				 if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
					strSql.append(W83bHistoricosBD.C_TERRIT_078).append("=").append(param.getTerritorio());	
				}else{
					strSql.append("(").append(W83bHistoricosBD.C_TERRIT_078).append("= '01' ");
					strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_078).append("= '48' ");
					strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_078).append("= '20') ");
				}
					
				strSql.append(" AND ").append(W83bHistoricosBD.MES_RES_078).append("=").append(param.getMes());	
				strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_078).append("=").append(param.getAnyo());	
				
				List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);
				W83bHistoricosBean criteriosBean = (W83bHistoricosBean)lista.get(0);
				
				criteriosBean.setAnyo(param.getAnyo());
				criteriosBean.setMes(param.getMes());
				criteriosBean.setTerritorio(param.getTerritorio());
				criteriosBean.setPorcentaje(param.getPorcentaje());
				criteriosBean.setDescTerritorio(param.getDescTerritorio());
				
			
				strSql.delete(0, strSql.length());
				strSql.append("SELECT NVL(SUM(").append(W83bHistoricosBD.N_DEMH49_077).append("),0) AS HASTA49,  NVL(SUM(");
				strSql.append(W83bHistoricosBD.N_DEMM49_077).append("),0) AS MAS49, NVL(SUM(");
				strSql.append(W83bHistoricosBD.N_DEMH49_077).append("+");
				strSql.append(W83bHistoricosBD.N_DEMM49_077).append("),0) AS TOTALDELEG FROM ");
				strSql.append(W83bHistoricosBD.tabla77).append(" WHERE ");
				strSql.append(W83bHistoricosBD.MES_RES_077).append("=").append(param.getMes());
				strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_077).append("=").append(param.getAnyo()).append(" AND ");
				
				if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
					strSql.append(W83bHistoricosBD.C_TERRIT_077).append("=").append(param.getTerritorio());	
				}
				else{
					strSql.append("(").append(W83bHistoricosBD.C_TERRIT_077).append("= '20' ");
					strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_077).append("= '01' ");
					strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_077).append("= '48' )");
				}
				List listaDeleg = W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);	
				W83bHistoricosBean criteriosBean2 = (W83bHistoricosBean)listaDeleg.get(0);
				criteriosBean.setHasta49(criteriosBean2.getHasta49());
				criteriosBean.setMas49(criteriosBean2.getMas49());
				criteriosBean.setTotDel(criteriosBean2.getTotDel());
				
				criteriosBean.setTotDelAlava(this.totalDelegadosTerritorio("01",  param));
				criteriosBean.setTotDelBizkaia(this.totalDelegadosTerritorio("48",  param));
				criteriosBean.setTotDelGipuzkoa(this.totalDelegadosTerritorio("20",  param));
			
				List resultados = new ArrayList();
				
			if("".equals(param.getPorcentaje())){	
				
				List lista2 =this.obtenerDatosSindicatos(param,"");
				W83bHistoricosBean elDato = new W83bHistoricosBean();//NOPMD
				HashMap map = new HashMap();//NOPMD
				
				for(int j=0;j<lista2.size();j++){
					elDato = (W83bHistoricosBean)lista2.get(j);	
					map.put(elDato.getSiglas()+elDato.getConvenio()+elDato.getTerritorio(), elDato.getTotalDelegados());
					elDato.setMap(map);
					resultados.add(elDato);
				}
			}else{
				//SE HA ELEGIDO UN PORCENTAJE
				resultados = this.calcularPorcentaje(param);			
			}
			
			resultado.add(criteriosBean);
			resultado.add(resultados);
		}	
			return resultado;
		
	}
	
	
	
	public List w83bCargaCuadroResumenHistClasif (W83bHistoricosBean param)throws Exception{
		List resultado = new ArrayList();
		
		if(this.hayRegistros(param)){
			List params = new ArrayList();
			
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);		
			//Sin porcentaje (se saca cada lnea con su porcentaje)
			
			strSql.append("SELECT NVL(SUM(");		
			strSql.append(W83bHistoricosBD.T_EMPRH49_078).append("),0) AS NUMEMPRESAS, NVL(SUM(");
			strSql.append(W83bHistoricosBD.T_ELECHH49_078).append("+");
			strSql.append(W83bHistoricosBD.T_ELECMH49_078).append("+");
			strSql.append(W83bHistoricosBD.T_ELECNH49_078).append("),0) AS TOTELECTORES, NVL(SUM(");
			strSql.append(W83bHistoricosBD.T_VOTAH49_078).append("),0) AS TOTVOTANTES, NVL(SUM(").append(W83bHistoricosBD.T_CENTH49_078).append("),0) AS TOTCENTROS ");
			strSql.append(" FROM ").append(W83bHistoricosBD.tabla78).append(" WHERE ");
			if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
				strSql.append(W83bHistoricosBD.C_TERRIT_078).append("=").append(param.getTerritorio());	
			}else{
				strSql.append("(").append(W83bHistoricosBD.C_TERRIT_078).append("= '01' ").append(" OR ");
				strSql.append(W83bHistoricosBD.C_TERRIT_078).append("= '48' ").append(" OR ");
				strSql.append(W83bHistoricosBD.C_TERRIT_078).append("= '20') ");
			}
			strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_078).append("=").append(param.getAnyo());	
			strSql.append(" AND ").append(W83bHistoricosBD.MES_RES_078).append("=").append(param.getMes());	
			
			
			List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);
			W83bHistoricosBean criteriosBean = (W83bHistoricosBean)lista.get(0);
			criteriosBean.setTerritorio(param.getTerritorio());
			criteriosBean.setAnyo(param.getAnyo());
			criteriosBean.setPorcentaje(param.getPorcentaje());
			criteriosBean.setDescTerritorio(param.getDescTerritorio());
			criteriosBean.setMes(param.getMes());
			
			strSql.delete(0, strSql.length());
			strSql.append("SELECT NVL(SUM(").append(W83bHistoricosBD.N_DEMH49_077).append("),0) AS HASTA49,  NVL(SUM(");
			strSql.append(W83bHistoricosBD.N_DEMM49_077).append("),0) AS MAS49, NVL(SUM(");
			strSql.append(W83bHistoricosBD.N_DEMH49_077).append("+").append(W83bHistoricosBD.N_DEMM49_077).append("),0) AS TOTALDELEG FROM ");
			strSql.append(W83bHistoricosBD.tabla77).append(" WHERE ");
			strSql.append(W83bHistoricosBD.MES_RES_077).append("=").append(param.getMes());
			strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_077).append("=").append(param.getAnyo()).append(" AND ");
			if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio()))
			{
				strSql.append(W83bHistoricosBD.C_TERRIT_077).append("=").append(param.getTerritorio());	
			}
			else
			{
				strSql.append("(").append(W83bHistoricosBD.C_TERRIT_077).append("= '01' ");
				strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_077).append("= '20' ").append(" OR ");
				strSql.append(W83bHistoricosBD.C_TERRIT_077).append("= '48' )");
			}
			List listaDeleg = W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);	
			
			W83bHistoricosBean criteriosBean2 = (W83bHistoricosBean)listaDeleg.get(0);
			criteriosBean.setMas49(criteriosBean2.getMas49());
			criteriosBean.setHasta49(criteriosBean2.getHasta49());
			criteriosBean.setTotDel(criteriosBean2.getTotDel());
			
			criteriosBean.setTotDelAlava(this.totalDelegadosTerritorio("01",  param));
			criteriosBean.setTotDelGipuzkoa(this.totalDelegadosTerritorio("20",  param));
			criteriosBean.setTotDelBizkaia(this.totalDelegadosTerritorio("48",  param));
			
			criteriosBean.setTotDelAlavaHasta49(this.totalDelegadosTerritorioHasta49("01",  param));			
			criteriosBean.setTotDelGipuzkoaHasta49(this.totalDelegadosTerritorioHasta49("20",  param));
			criteriosBean.setTotDelBizkaiaHasta49(this.totalDelegadosTerritorioHasta49("48",  param));
			
			
			
			List resultados = new ArrayList();
			
			if("".equals(param.getPorcentaje())){	
				
				List lista2 =this.obtenerDatosSindicatosHasta49(param,"");
				W83bHistoricosBean elDato = new W83bHistoricosBean();//NOPMD
				HashMap map = new HashMap();//NOPMD
				
				for(int j=0;j<lista2.size();j++){
					elDato = (W83bHistoricosBean)lista2.get(j);	
					map.put(elDato.getSiglas()+elDato.getConvenio()+elDato.getTerritorio(), elDato.getTotalDelegados());
					elDato.setMap(map);
					resultados.add(elDato);
				}
			}else{
				//SE HA ELEGIDO UN PORCENTAJE
				resultados = this.calcularPorcentajeHasta49(param);			
			}
			
			resultado.add(criteriosBean);
			resultado.add(resultados);
			
			params = new ArrayList();
			
			strSql = new StringBuffer(W83bClsConstantes.CUARENTA);		
			//Sin porcentaje (se saca cada lnea con su porcentaje)
			
			strSql.append("SELECT NVL(SUM(");
			strSql.append(W83bHistoricosBD.T_EMPRM49_078).append("),0) AS NUMEMPRESAS, NVL(SUM(");
			strSql.append(W83bHistoricosBD.T_ELECHM49_078).append("+");
			strSql.append(W83bHistoricosBD.T_ELECMM49_078).append("+");
			strSql.append(W83bHistoricosBD.T_ELECNM49_078).append("),0) AS TOTELECTORES, NVL(SUM(");
			strSql.append(W83bHistoricosBD.T_VOTAM49_078).append("),0) AS TOTVOTANTES, NVL(SUM(");
			strSql.append(W83bHistoricosBD.T_CENTM49_078).append("),0) AS TOTCENTROS ");
			strSql.append(" FROM ").append(W83bHistoricosBD.tabla78).append(" WHERE ");
			if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
				strSql.append(W83bHistoricosBD.C_TERRIT_078).append("=").append(param.getTerritorio());	
			}else{
				strSql.append("(").append(W83bHistoricosBD.C_TERRIT_078).append("= '01' ");
				strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_078).append("= '48' ");
				strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_078).append("= '20') ");
			}
			
			strSql.append(" AND ").append(W83bHistoricosBD.MES_RES_078).append("=").append(param.getMes());	
			strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_078).append("=").append(param.getAnyo());	
			
			lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);
			criteriosBean = (W83bHistoricosBean)lista.get(0);
			criteriosBean.setTerritorio(param.getTerritorio());
			criteriosBean.setAnyo(param.getAnyo());
			criteriosBean.setMes(param.getMes());
			criteriosBean.setPorcentaje(param.getPorcentaje());
			criteriosBean.setDescTerritorio(param.getDescTerritorio());
			
			
			strSql.delete(0, strSql.length());
			strSql.append("SELECT NVL(SUM(").append(W83bHistoricosBD.N_DEMH49_077).append("),0) AS HASTA49,  NVL(SUM(");
			strSql.append(W83bHistoricosBD.N_DEMM49_077).append("),0) AS MAS49, NVL(SUM(");
			strSql.append(W83bHistoricosBD.N_DEMH49_077).append("+").append(W83bHistoricosBD.N_DEMM49_077);
			strSql.append("),0) AS TOTALDELEG FROM ");
			strSql.append(W83bHistoricosBD.tabla77).append(" WHERE ");
			strSql.append(W83bHistoricosBD.MES_RES_077).append("=").append(param.getMes());
			strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_077).append("=").append(param.getAnyo()).append(" AND ");
			if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
				strSql.append(W83bHistoricosBD.C_TERRIT_077).append("=").append(param.getTerritorio());	
			}
			else{
				strSql.append("(").append(W83bHistoricosBD.C_TERRIT_077).append("= '01' ");
				strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_077).append("= '20' ");
				strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_077).append("= '48' )");
			}
			listaDeleg = W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);	
			criteriosBean2 = (W83bHistoricosBean)listaDeleg.get(0);
			criteriosBean.setHasta49(criteriosBean2.getHasta49());
			criteriosBean.setMas49(criteriosBean2.getMas49());
			criteriosBean.setTotDel(criteriosBean2.getTotDel());
			
			criteriosBean.setTotDelAlava(this.totalDelegadosTerritorio("01",  param));
			criteriosBean.setTotDelBizkaia(this.totalDelegadosTerritorio("48",  param));
			criteriosBean.setTotDelGipuzkoa(this.totalDelegadosTerritorio("20",  param));
			
			criteriosBean.setTotDelAlavaMas49(this.totalDelegadosTerritorioMas49("01",  param));
			criteriosBean.setTotDelGipuzkoaMas49(this.totalDelegadosTerritorioMas49("20",  param));
			criteriosBean.setTotDelBizkaiaMas49(this.totalDelegadosTerritorioMas49("48",  param));
			
			resultados = new ArrayList();
			
			if("".equals(param.getPorcentaje())){	
				
				List lista2 =this.obtenerDatosSindicatosMas49(param,"");
				W83bHistoricosBean elDato = new W83bHistoricosBean();//NOPMD
				HashMap map = new HashMap();//NOPMD
				
				for(int j=0;j<lista2.size();j++){
					elDato = (W83bHistoricosBean)lista2.get(j);	
					map.put(elDato.getSiglas()+elDato.getConvenio()+elDato.getTerritorio(), elDato.getTotalDelegados());
					elDato.setMap(map);
					resultados.add(elDato);
				}
			}else{
				//SE HA ELEGIDO UN PORCENTAJE
				resultados = this.calcularPorcentajeMas49(param);			
			}
			
			resultado.add(criteriosBean);
			resultado.add(resultados);
			
		}	
		
		return resultado;
	}
	
	
	

	
	public List calcularPorcentaje (W83bHistoricosBean param)throws Exception{
		List resultados = new ArrayList();
		
		Integer totalDelegados = new Integer(this.totalDelegadosTerritorio(param.getTerritorio(), param));
		
		List totalDelegSindicato = this.totalDelegSindicato(param.getTerritorio(), param);
		String porc=param.getPorcentaje().replace(',','.');
		Double  porcentajeFiltro = new Double(porc);
		//List params = new ArrayList();
		W83bHistoricosBean elDato = new W83bHistoricosBean();
		HashMap map = new HashMap();//NOPMD
		
		int funcionariosAlava = 0;
		int funcionariosBizkaia= 0;
		int funcionariosGipuzkoa= 0;
		int laboralesAlava= 0;
		int laboralesBizkaia= 0;
		int laboralesGipuzkoa= 0; 
		
		for(int i=0;i<totalDelegSindicato.size();i++){
			elDato = (W83bHistoricosBean)totalDelegSindicato.get(i);
			
			//miro a ver si el porcentaje de la lnea que estoy tratando supera el introducido en pantalla
			Integer totalDelegSind = new Integer(elDato.getTotalDelegados());//NOPMD
			float porcentajeRegistro = ((float)totalDelegSind.intValue()*100)/(float)totalDelegados.intValue();	
			
			if(porcentajeRegistro>=porcentajeFiltro.floatValue()){
				W83bHistoricosBean elRegistro = new W83bHistoricosBean();//NOPMD
				List lista =this.obtenerDatosSindicatos(param, elDato.getSiglas());
							
				for(int j=0;j<lista.size();j++){
					elRegistro = (W83bHistoricosBean)lista.get(j);	
					map.put(elRegistro.getSiglas()+elRegistro.getConvenio()+elRegistro.getTerritorio(), elRegistro.getTotalDelegados());
					elRegistro.setMap(map);
					resultados.add(elRegistro);
				}
			}else{
				List listaOtros =this.obtenerDatosSindicatos(param, elDato.getSiglas());
				W83bHistoricosBean elRegistroOtro = new W83bHistoricosBean();//NOPMD	
				for(int j=0;j<listaOtros.size();j++){
					elRegistroOtro = (W83bHistoricosBean)listaOtros.get(j);	
			
					if("48".equals(elRegistroOtro.getTerritorio()) && "0".equals(elRegistroOtro.getConvenio())){
						laboralesBizkaia = laboralesBizkaia+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}
					else if("48".equals(elRegistroOtro.getTerritorio()) && "1".equals(elRegistroOtro.getConvenio())){
						funcionariosBizkaia = funcionariosBizkaia+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}
					else if("1".equals(elRegistroOtro.getTerritorio()) && "0".equals(elRegistroOtro.getConvenio())){
						laboralesAlava = laboralesAlava+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}
					else if("1".equals(elRegistroOtro.getTerritorio()) && "1".equals(elRegistroOtro.getConvenio())){
						funcionariosAlava = funcionariosAlava+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}
					else if("20".equals(elRegistroOtro.getTerritorio()) && "0".equals(elRegistroOtro.getConvenio())){
						laboralesGipuzkoa = laboralesGipuzkoa+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}
					else if("20".equals(elRegistroOtro.getTerritorio()) && "1".equals(elRegistroOtro.getConvenio())){
						funcionariosGipuzkoa = funcionariosGipuzkoa+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}
				
				}
								
			}
			
		}
		
		if("01".equals(param.getTerritorio())){
			param.setTerritorio("1");
		}
		
		W83bHistoricosBean elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"0"+"1", laboralesAlava+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"1"+"1", funcionariosAlava+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"0"+"20", laboralesGipuzkoa+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"1"+"20", funcionariosGipuzkoa+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"0"+"48", laboralesBizkaia+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"1"+"48", funcionariosBizkaia+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		return resultados;
	}
	
	public List calcularPorcentajeHasta49 (W83bHistoricosBean param)throws Exception{
		
		Integer totalDelegados = new Integer(this.totalDelegadosTerritorioHasta49(param.getTerritorio(), param));
		List totalDelegSindicato = this.totalDelegSindicatoHasta49(param.getTerritorio(), param);
		List resultados = new ArrayList();
		
		String porc=param.getPorcentaje().replace(',','.');
		Double  porcentajeFiltro = new Double(porc);
			
		W83bHistoricosBean elDato = new W83bHistoricosBean();
		HashMap map = new HashMap();//NOPMD
		
		int funcionariosAlava = 0;
		int funcionariosGipuzkoa= 0;
		int funcionariosBizkaia= 0;
		int laboralesGipuzkoa= 0; 
		int laboralesBizkaia= 0;
		int laboralesAlava= 0;
		
		
		
		for(int i=0;i<totalDelegSindicato.size();i++){
			elDato = (W83bHistoricosBean)totalDelegSindicato.get(i);
			
			//miro a ver si el porcentaje de la lnea que estoy tratando supera el introducido en pantalla
			Integer totalDelegSind = new Integer(elDato.getTotalDelegados());//NOPMD
			float porcentajeRegistro = ((float)totalDelegSind.intValue()*100)/(float)totalDelegados.intValue();	
			if(porcentajeRegistro>=porcentajeFiltro.floatValue()){
				
				List lista =this.obtenerDatosSindicatosHasta49(param, elDato.getSiglas());
				W83bHistoricosBean elRegistro = new W83bHistoricosBean();//NOPMD				
				
				for(int k=0;k<lista.size();k++){
					elRegistro = (W83bHistoricosBean)lista.get(k);	
					map.put(elRegistro.getSiglas()+elRegistro.getConvenio()+elRegistro.getTerritorio(), elRegistro.getTotalDelegados());
					elRegistro.setMap(map);
					resultados.add(elRegistro);
				}
			}
			else{
				
				//si no supera el porcentaje, tienen que ir en la misma lnea como OTROS
				W83bHistoricosBean elRegistroOtro = new W83bHistoricosBean();//NOPMD
				List listaOtros =this.obtenerDatosSindicatosHasta49(param, elDato.getSiglas());
				for(int j=0;j<listaOtros.size();j++){
					elRegistroOtro = (W83bHistoricosBean)listaOtros.get(j);	
					
					if("48".equals(elRegistroOtro.getTerritorio()) && "0".equals(elRegistroOtro.getConvenio())){
						laboralesBizkaia = laboralesBizkaia+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}else if("48".equals(elRegistroOtro.getTerritorio()) && "1".equals(elRegistroOtro.getConvenio())){
						funcionariosBizkaia = funcionariosBizkaia+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}else if("20".equals(elRegistroOtro.getTerritorio()) && "0".equals(elRegistroOtro.getConvenio())){
						laboralesGipuzkoa = laboralesGipuzkoa+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}else if("20".equals(elRegistroOtro.getTerritorio()) && "1".equals(elRegistroOtro.getConvenio())){
						funcionariosGipuzkoa = funcionariosGipuzkoa+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}else if("1".equals(elRegistroOtro.getTerritorio()) && "0".equals(elRegistroOtro.getConvenio())){
						laboralesAlava = laboralesAlava+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}else if("1".equals(elRegistroOtro.getTerritorio()) && "1".equals(elRegistroOtro.getConvenio())){
						funcionariosAlava = funcionariosAlava+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}
					
				}
				
			}
			
		}
		
		if("01".equals(param.getTerritorio())){
			param.setTerritorio("1");
		}
		
		W83bHistoricosBean elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"0"+"1", laboralesAlava+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"1"+"1", funcionariosAlava+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"0"+"48", laboralesBizkaia+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"1"+"48", funcionariosBizkaia+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"0"+"20", laboralesGipuzkoa+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"1"+"20", funcionariosGipuzkoa+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		
		
		return resultados;
	}

	public List calcularPorcentajeMas49 (W83bHistoricosBean param)throws Exception{
		List resultados = new ArrayList();
		
		Integer totalDelegados = new Integer(this.totalDelegadosTerritorioMas49(param.getTerritorio(), param));
		
		List totalDelegSindicato = this.totalDelegSindicatoMas49(param.getTerritorio(), param);
		String porc=param.getPorcentaje().replace(',','.');
		Double  porcentajeFiltro = new Double(porc);
		
		W83bHistoricosBean elDato = new W83bHistoricosBean();
		HashMap map = new HashMap();//NOPMD
		
		int laboralesAlava= 0;
		int laboralesBizkaia= 0;
		int laboralesGipuzkoa= 0; 
		int funcionariosAlava = 0;
		int funcionariosBizkaia= 0;
		int funcionariosGipuzkoa= 0;
		
		
		for(int i=0;i<totalDelegSindicato.size();i++){
			elDato = (W83bHistoricosBean)totalDelegSindicato.get(i);
			Integer totalDelegSind = new Integer(elDato.getTotalDelegados());//NOPMD
			float porcentajeRegistro2 = ((float)totalDelegSind.intValue()*100)/(float)totalDelegados.intValue();	
			if(porcentajeRegistro2>=porcentajeFiltro.floatValue())
			{
				W83bHistoricosBean elRegistro = new W83bHistoricosBean();//NOPMD
				List lista3 =this.obtenerDatosSindicatosMas49(param, elDato.getSiglas());
				for(int j=0;j<lista3.size();j++)
				{
					elRegistro = (W83bHistoricosBean)lista3.get(j);	
					map.put(elRegistro.getSiglas()+elRegistro.getConvenio()+elRegistro.getTerritorio(), elRegistro.getTotalDelegados());
					elRegistro.setMap(map);
					resultados.add(elRegistro);
				}
			}
			else
			{
				
				//si no supera el porcentaje, tienen que ir en la misma lnea como OTROS
				List listaOtros =this.obtenerDatosSindicatosMas49(param, elDato.getSiglas());
				W83bHistoricosBean elRegistroOtro = new W83bHistoricosBean();//NOPMD	
				for(int j=0;j<listaOtros.size();j++){
					elRegistroOtro = (W83bHistoricosBean)listaOtros.get(j);	
					
					if("48".equals(elRegistroOtro.getTerritorio()) && "0".equals(elRegistroOtro.getConvenio())){
						laboralesBizkaia = laboralesBizkaia+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}
					else if("20".equals(elRegistroOtro.getTerritorio()) && "0".equals(elRegistroOtro.getConvenio())){
						laboralesGipuzkoa = laboralesGipuzkoa+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}else if("1".equals(elRegistroOtro.getTerritorio()) && "0".equals(elRegistroOtro.getConvenio())){
						laboralesAlava = laboralesAlava+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}else if("48".equals(elRegistroOtro.getTerritorio()) && "1".equals(elRegistroOtro.getConvenio())){
						funcionariosBizkaia = funcionariosBizkaia+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}else if("20".equals(elRegistroOtro.getTerritorio()) && "1".equals(elRegistroOtro.getConvenio())){
						funcionariosGipuzkoa = funcionariosGipuzkoa+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}else if("1".equals(elRegistroOtro.getTerritorio()) && "1".equals(elRegistroOtro.getConvenio())){
						funcionariosAlava = funcionariosAlava+(new Integer(elRegistroOtro.getTotalDelegados()).intValue());//NOPMD
					}
					
				}
				
			}
			
		}
		
		if("01".equals(param.getTerritorio())){
			param.setTerritorio("1");
		}
		
		W83bHistoricosBean elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"1"+"1", funcionariosAlava+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		elReg = new W83bHistoricosBean();//NOPMD
		map.put("OTROS"+"0"+"1", laboralesAlava+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"1"+"20", funcionariosGipuzkoa+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"0"+"20", laboralesGipuzkoa+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"1"+"48", funcionariosBizkaia+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		elReg = new W83bHistoricosBean();//NOPMD	
		map.put("OTROS"+"0"+"48", laboralesBizkaia+"");
		elReg.setSiglas("OTROS");
		elReg.setMap(map);
		elReg.setTerritorio(param.getTerritorio());
		resultados.add(elReg);
		
		return resultados;
	}
	
	
	public List obtenerDatosSindicatos (W83bHistoricosBean param, String siglas) throws Exception{
		
		List params = new ArrayList();
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		strSql.append("SELECT ").append(W83bHistoricosBD.SIGLAS_019).append(",").append(W83bHistoricosBD.DESC_019).append(",").append(W83bHistoricosBD.DESE_019);
		strSql.append(",(CASE  WHEN (SUBSTR (");
		strSql.append(W83bHistoricosBD.C_CONV_077).append(", 1, 1) = 9 AND LENGTH(");
		strSql.append(W83bHistoricosBD.C_CONV_077).append(")=3) THEN '1' ELSE '0' END) AS C_CONV_077,");
		strSql.append("SUM(").append(W83bHistoricosBD.N_DEMH49_077).append("+").append(W83bHistoricosBD.N_DEMM49_077);
		strSql.append(") AS TOTDEL").append(",").append(W83bHistoricosBD.C_TERRIT_077);
		strSql.append(" , ").append(W83bHistoricosBD.totdel).append(" AS TOTALDELEGADOS ");	
				
		strSql.append(" FROM ").append(W83bHistoricosBD.tabla77).append(",").append(W83bHistoricosBD.tabla19);
		
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			strSql.append(" , ").append(W83bHistoricosBD.w83bcuadroresumenhistorico);
		}else{
			strSql.append(" , ").append(W83bHistoricosBD.w83bcuadroresumenhistoricocav);
		}
		strSql.append(" WHERE ");
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			strSql.append(W83bHistoricosBD.C_TERRIT_077).append("=").append(param.getTerritorio());	
		}else{
			strSql.append("(").append(W83bHistoricosBD.C_TERRIT_077).append("= '01' ");
			strSql.append(" OR ");
			strSql.append(W83bHistoricosBD.C_TERRIT_077).append("= '48' ");
			strSql.append(" OR ");
			strSql.append(W83bHistoricosBD.C_TERRIT_077).append("= '20') ");
		}
		if(!"".equals(siglas)){ 
			strSql.append(" AND ").append(W83bHistoricosBD.SIGLAS_019).append("='").append(siglas).append("' ");
		}
		
		strSql.append(" AND ").append(W83bHistoricosBD.C_SINDI_077).append("=").append(W83bHistoricosBD.C_SINDI_019);
		strSql.append(" AND ").append(W83bHistoricosBD.MES_RES_077).append("=").append(param.getMes());
		strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_077).append("=").append(param.getAnyo());
		strSql.append(" AND ").append(W83bHistoricosBD.siglas).append("=").append(W83bHistoricosBD.SIGLAS_019);
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			strSql.append(" AND ").append(W83bHistoricosBD.territ).append("=").append(W83bHistoricosBD.C_TERRIT_077);
		}
		strSql.append(" AND ").append(W83bHistoricosBD.mes).append("=").append(W83bHistoricosBD.MES_RES_077);
		strSql.append(" AND ").append(W83bHistoricosBD.anyo).append("=").append(W83bHistoricosBD.ANO_RES_077);
		
		
		strSql.append(" GROUP BY  ").append(W83bHistoricosBD.SIGLAS_019).append(",").append(W83bHistoricosBD.DESC_019).append(",").append(W83bHistoricosBD.DESE_019);
		strSql.append(",(CASE  WHEN (SUBSTR (");
		strSql.append(W83bHistoricosBD.C_CONV_077).append(", 1, 1) = 9 AND LENGTH(");
		strSql.append(W83bHistoricosBD.C_CONV_077).append(")=3) THEN '1' ELSE '0' END)").append(",");
		strSql.append(W83bHistoricosBD.C_TERRIT_077).append(",");
		strSql.append(W83bHistoricosBD.totdel);
		strSql.append(" ORDER BY totaldelegados DESC ");
	
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);	
	}
	
	public List obtenerDatosSindicatosHasta49 (W83bHistoricosBean param, String siglas) throws Exception{
		
		List params = new ArrayList();
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		strSql.append("SELECT ").append(W83bHistoricosBD.SIGLAS_019).append(",").append(W83bHistoricosBD.DESC_019).append(",").append(W83bHistoricosBD.DESE_019);
		strSql.append(",(CASE  WHEN (SUBSTR (").append(W83bHistoricosBD.C_CONV_077).append(", 1, 1) = 9 AND LENGTH(");
		strSql.append(W83bHistoricosBD.C_CONV_077).append(")=3) THEN '1' ELSE '0' END) AS C_CONV_077,");
		strSql.append("SUM(").append(W83bHistoricosBD.N_DEMH49_077);
		strSql.append(") AS TOTDEL").append(",").append(W83bHistoricosBD.C_TERRIT_077);
		strSql.append(" , ").append(W83bHistoricosBD.hasta49).append(" AS TOTALDELEGADOS ");
		strSql.append(" FROM ").append(W83bHistoricosBD.tabla77).append(",").append(W83bHistoricosBD.tabla19);
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			strSql.append(" , ").append(W83bHistoricosBD.w83bcuadroresumenhistorico);
		}else{
			strSql.append(" , ").append(W83bHistoricosBD.w83bcuadroresumenhistoricocav);
		}
		strSql.append(" WHERE ");
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			strSql.append(W83bHistoricosBD.C_TERRIT_077).append("=").append(param.getTerritorio());	
		}
		else{
			strSql.append("(").append(W83bHistoricosBD.C_TERRIT_077).append("= '01' ");
			strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_077).append("= '48' ");
			strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_077).append("= '20') ");
		}
		if(!"".equals(siglas)){ 
			strSql.append(" AND ").append(W83bHistoricosBD.SIGLAS_019).append("='").append(siglas).append("' ");
		}
		
		strSql.append(" AND ").append(W83bHistoricosBD.MES_RES_077).append("=").append(param.getMes());
		strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_077).append("=").append(param.getAnyo());
		strSql.append(" AND ").append(W83bHistoricosBD.C_SINDI_077).append("=").append(W83bHistoricosBD.C_SINDI_019);
		
		strSql.append(" AND ").append(W83bHistoricosBD.C_SINDI_077).append("=").append(W83bHistoricosBD.C_SINDI_019);
		strSql.append(" AND ").append(W83bHistoricosBD.MES_RES_077).append("=").append(param.getMes());
		strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_077).append("=").append(param.getAnyo());
		strSql.append(" AND ").append(W83bHistoricosBD.siglas).append("=").append(W83bHistoricosBD.SIGLAS_019);
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			strSql.append(" AND ").append(W83bHistoricosBD.territ).append("=").append(W83bHistoricosBD.C_TERRIT_077);
		}
		strSql.append(" AND ").append(W83bHistoricosBD.mes).append("=").append(W83bHistoricosBD.MES_RES_077);
		strSql.append(" AND ").append(W83bHistoricosBD.anyo).append("=").append(W83bHistoricosBD.ANO_RES_077);
		
		strSql.append(" GROUP BY  ").append(W83bHistoricosBD.SIGLAS_019).append(",").append(W83bHistoricosBD.DESC_019).append(",").append(W83bHistoricosBD.DESE_019);
		strSql.append(",(CASE  WHEN (SUBSTR (");
		strSql.append(W83bHistoricosBD.C_CONV_077).append(", 1, 1) = 9 AND LENGTH(");
		strSql.append(W83bHistoricosBD.C_CONV_077).append(")=3) THEN '1' ELSE '0' END)");
		strSql.append(",").append(W83bHistoricosBD.C_TERRIT_077);
		strSql.append(" , ").append(W83bHistoricosBD.hasta49);
		strSql.append(" ORDER BY totaldelegados DESC ");
			
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);	
	}
	
	public List obtenerDatosSindicatosMas49 (W83bHistoricosBean param, String siglas) throws Exception{
		
		List params = new ArrayList();
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		strSql.append("SELECT ").append(W83bHistoricosBD.SIGLAS_019).append(",").append(W83bHistoricosBD.DESC_019).append(",").append(W83bHistoricosBD.DESE_019);
		strSql.append(",(CASE  WHEN (SUBSTR (");
		strSql.append(W83bHistoricosBD.C_CONV_077).append(", 1, 1) = 9 AND LENGTH(").append(W83bHistoricosBD.C_CONV_077);
		strSql.append(")=3) THEN '1' ELSE '0' END) AS C_CONV_077,").append("SUM(").append(W83bHistoricosBD.N_DEMM49_077);
		strSql.append(") AS TOTDEL").append(",").append(W83bHistoricosBD.C_TERRIT_077);
		strSql.append(" , ").append(W83bHistoricosBD.mas49).append(" AS TOTALDELEGADOS ");
		strSql.append(" FROM ").append(W83bHistoricosBD.tabla77).append(",").append(W83bHistoricosBD.tabla19);
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			strSql.append(" , ").append(W83bHistoricosBD.w83bcuadroresumenhistorico);
		}else{
			strSql.append(" , ").append(W83bHistoricosBD.w83bcuadroresumenhistoricocav);
		}
		strSql.append(" WHERE ");
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			strSql.append(W83bHistoricosBD.C_TERRIT_077).append("=").append(param.getTerritorio());	
		}
		else
		{
			strSql.append("(").append(W83bHistoricosBD.C_TERRIT_077).append("= '01' OR ");
			strSql.append(W83bHistoricosBD.C_TERRIT_077).append("= '48' OR ");
			strSql.append(W83bHistoricosBD.C_TERRIT_077).append("= '20') ");
		}
		if(!"".equals(siglas)){ 
			strSql.append(" AND ").append(W83bHistoricosBD.SIGLAS_019).append("='").append(siglas).append("' ");
		}
		
		strSql.append(" AND ").append(W83bHistoricosBD.MES_RES_077).append("=").append(param.getMes());
		strSql.append(" AND ").append(W83bHistoricosBD.C_SINDI_077).append("=").append(W83bHistoricosBD.C_SINDI_019);
		strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_077).append("=").append(param.getAnyo());
		
		strSql.append(" AND ").append(W83bHistoricosBD.C_SINDI_077).append("=").append(W83bHistoricosBD.C_SINDI_019);
		strSql.append(" AND ").append(W83bHistoricosBD.MES_RES_077).append("=").append(param.getMes());
		strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_077).append("=").append(param.getAnyo());
		strSql.append(" AND ").append(W83bHistoricosBD.siglas).append("=").append(W83bHistoricosBD.SIGLAS_019);
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			strSql.append(" AND ").append(W83bHistoricosBD.territ).append("=").append(W83bHistoricosBD.C_TERRIT_077);
		}
		strSql.append(" AND ").append(W83bHistoricosBD.mes).append("=").append(W83bHistoricosBD.MES_RES_077);
		strSql.append(" AND ").append(W83bHistoricosBD.anyo).append("=").append(W83bHistoricosBD.ANO_RES_077);
		
		strSql.append(" GROUP BY  ").append(W83bHistoricosBD.SIGLAS_019).append(",").append(W83bHistoricosBD.DESC_019).append(",").append(W83bHistoricosBD.DESE_019);
		strSql.append(",(CASE  WHEN (SUBSTR (");
		strSql.append(W83bHistoricosBD.C_CONV_077).append(", 1, 1) = 9 AND LENGTH(").append(W83bHistoricosBD.C_CONV_077).append(")=3) THEN '1' ELSE '0' END)");
		strSql.append(",").append(W83bHistoricosBD.C_TERRIT_077);
		strSql.append(" , ").append(W83bHistoricosBD.mas49);
		strSql.append(" ORDER BY totaldelegados DESC ");
	
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);	
	}
	
	
	
	public String totalDelegadosTerritorio (String territorio, W83bHistoricosBean param)throws Exception
	
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		strSql.append("SELECT  NVL(SUM(");
		strSql.append(W83bHistoricosBD.N_DEMH49_077).append("+").append(W83bHistoricosBD.N_DEMM49_077);
		strSql.append("),0) AS TOTALDELEG FROM ");
		strSql.append(W83bHistoricosBD.tabla77).append(" WHERE ");
		strSql.append(W83bHistoricosBD.MES_RES_077).append("=").append(param.getMes());
		strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_077).append("=").append(param.getAnyo()).append(" AND ");
		if (territorio!=null&&!"null".equals(territorio)&&!"".equals(territorio)){
			strSql.append(W83bHistoricosBD.C_TERRIT_077).append("=").append(territorio);
		}else{
			strSql.append("(").append(W83bHistoricosBD.C_TERRIT_077).append("= '20' ");
			strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_077).append("= '48' ");
			strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_077).append("= '01') ");
		}
		strSql.append(" ORDER BY SUM(").append(W83bHistoricosBD.N_DEMH49_077).append("+").append(W83bHistoricosBD.N_DEMM49_077).append(") DESC");
		List params = new ArrayList();
		List listaDeleg = W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);	
		W83bHistoricosBean criteriosBean2 = (W83bHistoricosBean)listaDeleg.get(0);
		
		
		return criteriosBean2.getTotDel();
		
	}
	public String totalDelegadosTerritorioHasta49 (String territorio, W83bHistoricosBean param)throws Exception
	
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		strSql.append("SELECT  NVL(SUM(");
		strSql.append(W83bHistoricosBD.N_DEMH49_077);
		strSql.append("),0) AS TOTALDELEG FROM ");
		strSql.append(W83bHistoricosBD.tabla77).append(" WHERE ");
		strSql.append(W83bHistoricosBD.MES_RES_077).append("=").append(param.getMes());
		strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_077).append("=").append(param.getAnyo()).append(" AND ");
		if (territorio!=null&&!"null".equals(territorio)&&!"".equals(territorio)){
			strSql.append(W83bHistoricosBD.C_TERRIT_077).append("=").append(territorio);
		}else{
			strSql.append("(").append(W83bHistoricosBD.C_TERRIT_077).append("= '20' ");
			strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_077).append("= '48' ");
			strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_077).append("= '01') ");
		}
		
		strSql.append(" ORDER BY SUM(").append(W83bHistoricosBD.N_DEMH49_077).append(") DESC");
		List params = new ArrayList();
		List listaDeleg = W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);	
		W83bHistoricosBean criteriosBean2 = (W83bHistoricosBean)listaDeleg.get(0);
		
		
		return criteriosBean2.getTotDel();
		
	}
	public String totalDelegadosTerritorioMas49 (String territorio, W83bHistoricosBean param)throws Exception
	
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		strSql.append("SELECT  NVL(SUM(");
		strSql.append(W83bHistoricosBD.N_DEMM49_077);
		strSql.append("),0) AS TOTALDELEG FROM ");
		strSql.append(W83bHistoricosBD.tabla77).append(" WHERE ");
		strSql.append(W83bHistoricosBD.MES_RES_077).append("=").append(param.getMes());
		strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_077).append("=").append(param.getAnyo()).append(" AND ");
		if (territorio!=null&&!"null".equals(territorio)&&!"".equals(territorio)){
			strSql.append(W83bHistoricosBD.C_TERRIT_077).append("=").append(territorio);
		}else{
			strSql.append("(").append(W83bHistoricosBD.C_TERRIT_077).append("= '20' ");
			strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_077).append("= '48' ");
			strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_077).append("= '01') ");
		}
		strSql.append(" ORDER BY SUM(").append(W83bHistoricosBD.N_DEMM49_077).append(") DESC");
		List params = new ArrayList();
		List listaDeleg = W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);	
		W83bHistoricosBean criteriosBean2 = (W83bHistoricosBean)listaDeleg.get(0);
		
		
		return criteriosBean2.getTotDel();
		
	}
	
	public List totalDelegSindicato (String territorio, W83bHistoricosBean param)throws Exception
	
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		strSql.append("SELECT ").append(W83bHistoricosBD.SIGLAS_019).append(",").append(W83bHistoricosBD.DESC_019);
		strSql.append(",").append(W83bHistoricosBD.DESE_019).append(",SUM(").append(W83bHistoricosBD.N_DEMH49_077);
		strSql.append("+").append(W83bHistoricosBD.N_DEMM49_077).append(") AS TOTDEL FROM ");
		strSql.append(W83bHistoricosBD.tabla77).append(",").append(W83bHistoricosBD.tabla19).append(" WHERE ");
		strSql.append(W83bHistoricosBD.MES_RES_077).append("=").append(param.getMes());
		strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_077).append("=").append(param.getAnyo());
		strSql.append(" AND ").append(W83bHistoricosBD.C_SINDI_077).append("=").append(W83bHistoricosBD.C_SINDI_019);
		if (territorio!=null&&!"null".equals(territorio)&&!"".equals(territorio)){
			strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_077).append("=").append(territorio);
		}
		strSql.append(" GROUP BY ").append(W83bHistoricosBD.SIGLAS_019).append(",").append(W83bHistoricosBD.DESC_019);
		strSql.append(",").append(W83bHistoricosBD.DESE_019);
		strSql.append(" ORDER BY SUM(").append(W83bHistoricosBD.N_DEMH49_077).append("+");
		strSql.append(W83bHistoricosBD.N_DEMM49_077).append(") DESC");
		
		List params = new ArrayList();
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);			
		
	}
	
	public List totalDelegSindicatoHasta49 (String territorio, W83bHistoricosBean param)throws Exception
	{
		List params = new ArrayList();
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		strSql.append("SELECT ").append(W83bHistoricosBD.SIGLAS_019).append(",").append(W83bHistoricosBD.DESC_019);
		strSql.append(",").append(W83bHistoricosBD.DESE_019).append(",SUM(").append(W83bHistoricosBD.N_DEMH49_077);
		strSql.append(") AS TOTDEL FROM ").append(W83bHistoricosBD.tabla77).append(",").append(W83bHistoricosBD.tabla19);
		strSql.append(" WHERE ");
		strSql.append(W83bHistoricosBD.MES_RES_077).append("=").append(param.getMes());
		strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_077).append("=").append(param.getAnyo());
		strSql.append(" AND ").append(W83bHistoricosBD.C_SINDI_077).append("=").append(W83bHistoricosBD.C_SINDI_019);
		if (territorio!=null&&!"null".equals(territorio)&&!"".equals(territorio)){
			strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_077).append("=").append(territorio);
		}
		strSql.append(" GROUP BY ").append(W83bHistoricosBD.SIGLAS_019).append(",").append(W83bHistoricosBD.DESC_019);
		strSql.append(",").append(W83bHistoricosBD.DESE_019);
		strSql.append(" ORDER BY SUM(").append(W83bHistoricosBD.N_DEMH49_077).append(") DESC");
		
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);			
		
	}
	
	public List totalDelegSindicatoMas49 (String territorio, W83bHistoricosBean param)throws Exception
	
	{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		strSql.append("SELECT ").append(W83bHistoricosBD.SIGLAS_019).append(",").append(W83bHistoricosBD.DESC_019);
		strSql.append(",").append(W83bHistoricosBD.DESE_019).append(",SUM(").append(W83bHistoricosBD.N_DEMM49_077);
		strSql.append(") AS TOTDEL FROM ").append(W83bHistoricosBD.tabla77);
		strSql.append(",").append(W83bHistoricosBD.tabla19).append(" WHERE ");
		strSql.append(W83bHistoricosBD.MES_RES_077).append("=").append(param.getMes()).append(" AND ");
		strSql.append(W83bHistoricosBD.ANO_RES_077).append("=").append(param.getAnyo()).append(" AND ");
		strSql.append(W83bHistoricosBD.C_SINDI_077).append("=").append(W83bHistoricosBD.C_SINDI_019);
		if (territorio!=null&&!"null".equals(territorio)&&!"".equals(territorio)){
			strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_077).append("=").append(territorio);
		}
		strSql.append(" GROUP BY ").append(W83bHistoricosBD.SIGLAS_019).append(",");
		strSql.append(W83bHistoricosBD.DESC_019).append(",").append(W83bHistoricosBD.DESE_019);
		strSql.append(" ORDER BY SUM(").append(W83bHistoricosBD.N_DEMM49_077).append(") DESC");
		
		List params = new ArrayList();
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);			
		
	}
	
	public boolean hayRegistros (W83bHistoricosBean param) throws Exception {
		List params = new ArrayList();
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);		
				
		strSql.append("SELECT COUNT(");		
		strSql.append(W83bHistoricosBD.T_EMPRH49_078).append(") AS NUMEMPRESAS").append(" FROM ").append(W83bHistoricosBD.tabla78).append(" WHERE ");
		 if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			strSql.append(W83bHistoricosBD.C_TERRIT_078).append("=").append(param.getTerritorio());	
		}else{
			strSql.append("(").append(W83bHistoricosBD.C_TERRIT_078).append("= '48' ");
			strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_078).append("= '01' ");
			strSql.append(" OR ").append(W83bHistoricosBD.C_TERRIT_078).append("= '20') ");
		}
			
		strSql.append(" AND ").append(W83bHistoricosBD.MES_RES_078).append("=").append(param.getMes());	
		strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_078).append("=").append(param.getAnyo());	
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);
		W83bHistoricosBean criteriosBean = (W83bHistoricosBean)lista.get(0);
		
		strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		strSql.append("SELECT COUNT(").append(W83bHistoricosBD.SIGLAS_019).append(") AS ").append(W83bHistoricosBD.SIGLAS_019);
		strSql.append(" FROM ").append(W83bHistoricosBD.tabla77);
		strSql.append(",").append(W83bHistoricosBD.tabla19).append(" WHERE ");
		strSql.append(W83bHistoricosBD.MES_RES_077).append("=").append(param.getMes()).append(" AND ");
		strSql.append(W83bHistoricosBD.ANO_RES_077).append("=").append(param.getAnyo()).append(" AND ");
		strSql.append(W83bHistoricosBD.C_SINDI_077).append("=").append(W83bHistoricosBD.C_SINDI_019);
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_077).append("=").append(param.getTerritorio());
		}
		
		List lista2= W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);			
		W83bHistoricosBean criteriosBean2 = (W83bHistoricosBean)lista2.get(0);
		
		
		return (!"0".equals(criteriosBean.getTotEmpresas()) && !"0".equals(criteriosBean2.getSiglas()));
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIHistoricosDAO#w83bCargaRepCandTamHist(w83b.w83bBeans.W83bHistoricosBean)
	 */
	public List w83bCargaRepCandTamHist(W83bHistoricosBean param) throws Exception {
		List resultado = new ArrayList();

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);		
		strSql.append("SELECT ");		
		strSql.append(W83bHistoricosBD.C_TERRIT_081).append(", COMARCA.").append(W83bHistoricosBD.dso).append(",");
		
		if("false".equals(param.getPorComarca())){
			strSql.append(" MUNICIPIO.").append(W83bHistoricosBD.dsoMun).append(" AS MUNIC ,");
		}
		
		strSql.append("(CASE  WHEN (").append(W83bHistoricosBD.C_SINDI_019).append("<>'75' AND ");
		strSql.append(W83bHistoricosBD.C_SINDI_019).append(" <> '80' AND ").append(W83bHistoricosBD.C_SINDI_019).append("<>85 ");
		strSql.append(" AND  ").append(W83bHistoricosBD.C_SINDI_019).append(" <>'90' ) THEN 'OTROS' ELSE ");
		strSql.append(W83bHistoricosBD.SIGLAS_019).append(" END) AS ").append(W83bHistoricosBD.SIGLAS_019);
		strSql.append(", (CASE  WHEN (").append(W83bHistoricosBD.C_SINDI_019).append("<>'75' AND ");
		strSql.append(W83bHistoricosBD.C_SINDI_019).append(" <> '80' AND ").append(W83bHistoricosBD.C_SINDI_019).append("<>85 ");
		strSql.append(" AND  ").append(W83bHistoricosBD.C_SINDI_019).append(" <>'90' ) THEN '0' ELSE (");
		strSql.append(W83bHistoricosBD.C_SINDI_019).append("||'') END) AS ").append(W83bHistoricosBD.C_SINDI_019);
		strSql.append(", SUM(");
		strSql.append(W83bHistoricosBD.T_TRAB610_081).append(") AS ").append(W83bHistoricosBD.T_TRAB610_081).append(",SUM(");
		strSql.append(W83bHistoricosBD.T_TRAB1130_081).append(") AS ").append(W83bHistoricosBD.T_TRAB1130_081).append(",SUM(");
		strSql.append(W83bHistoricosBD.T_TRAB3149_081).append(") AS ").append(W83bHistoricosBD.T_TRAB3149_081).append(",SUM(");
		strSql.append(W83bHistoricosBD.T_TRAB50100_081).append(") AS ").append(W83bHistoricosBD.T_TRAB50100_081).append(",SUM(");
		strSql.append(W83bHistoricosBD.T_TRAB101250_081).append(") AS ").append(W83bHistoricosBD.T_TRAB101250_081).append(",SUM(");
		strSql.append(W83bHistoricosBD.T_TRAB251500_081).append(") AS ").append(W83bHistoricosBD.T_TRAB251500_081).append(",SUM(");
		strSql.append(W83bHistoricosBD.T_TRAB501750_081).append(") AS ").append(W83bHistoricosBD.T_TRAB501750_081).append(",SUM(");
		strSql.append(W83bHistoricosBD.T_TRAB7511000_081).append(") AS ").append(W83bHistoricosBD.T_TRAB7511000_081).append(",SUM(");
		strSql.append(W83bHistoricosBD.T_TRABM1000_081).append(") AS ").append(W83bHistoricosBD.T_TRABM1000_081).append(" FROM ");
		strSql.append(W83bHistoricosBD.tabla81).append(" ,  ");
		strSql.append(W83bHistoricosBD.tablacomarca).append(" COMARCA ,  ");
		if("false".equals(param.getPorComarca())){
			strSql.append(W83bHistoricosBD.tablamunicipio).append(" MUNICIPIO ,  ");
		}
		
		strSql.append(W83bHistoricosBD.tabla19).append(" WHERE  ");
		
		strSql.append(W83bHistoricosBD.C_COMAR_081).append("=COMARCA.").append(W83bHistoricosBD.comarcaid).append(" AND ");
		strSql.append(W83bHistoricosBD.C_TERRIT_081).append("=COMARCA.").append(W83bHistoricosBD.provinciaid).append(" AND ");
		
		if("false".equals(param.getPorComarca())){
			strSql.append(W83bHistoricosBD.C_MUNI_081).append("=MUNICIPIO.").append(W83bHistoricosBD.comarcaidMun).append(" AND ");
			strSql.append(W83bHistoricosBD.C_TERRIT_081).append("=MUNICIPIO.").append(W83bHistoricosBD.provinciaidMun).append(" AND ");
		}
		
		strSql.append(W83bHistoricosBD.MES_RES_081).append("=").append(param.getMes()).append(" AND ");
		strSql.append(W83bHistoricosBD.ANO_RES_081).append("=").append(param.getAnyo()).append(" AND ");
		strSql.append(W83bHistoricosBD.C_TERRIT_081).append("=").append(param.getTerritorio());
		strSql.append(" AND ").append(W83bHistoricosBD.C_SINDI_081).append("=").append(W83bHistoricosBD.C_SINDI_019);
		strSql.append(" GROUP BY ").append(W83bHistoricosBD.C_TERRIT_081).append(",COMARCA.").append(W83bHistoricosBD.dso);
		
		if("false".equals(param.getPorComarca())){
			strSql.append(",MUNICIPIO.").append(W83bHistoricosBD.dso);
			
		}
		
		strSql.append(" , ").append("(CASE  WHEN (").append(W83bHistoricosBD.C_SINDI_019).append("<>'75' AND ");
		strSql.append(W83bHistoricosBD.C_SINDI_019).append(" <> '80' AND ").append(W83bHistoricosBD.C_SINDI_019).append("<>85 ");
		strSql.append(" AND  ").append(W83bHistoricosBD.C_SINDI_019).append(" <>'90' ) THEN 'OTROS' ELSE ");
		strSql.append(W83bHistoricosBD.SIGLAS_019).append(" END) , ");
		strSql.append(" (CASE  WHEN (").append(W83bHistoricosBD.C_SINDI_019).append("<>'75' AND ");
		strSql.append(W83bHistoricosBD.C_SINDI_019).append(" <> '80' AND ").append(W83bHistoricosBD.C_SINDI_019).append("<>85 ");
		strSql.append(" AND  ").append(W83bHistoricosBD.C_SINDI_019).append(" <>'90' ) THEN '0' ELSE (");
		strSql.append(W83bHistoricosBD.C_SINDI_019).append("||'') END) ORDER BY ");
		strSql.append(W83bHistoricosBD.C_TERRIT_081).append(",COMARCA.").append(W83bHistoricosBD.dso);
		
		if("false".equals(param.getPorComarca())){
			strSql.append(",MUNICIPIO.").append(W83bHistoricosBD.dso);
			
		}
		
		strSql.append(",").append(W83bHistoricosBD.C_SINDI_019).append(" DESC ");
		
		resultado =  W83bDataBase.executeQuery(strSql.toString(),resultado,W83bHistoricosBean.class,param.getUsuarioBean(), null);
		
		W83bHistoricosBean dato = new W83bHistoricosBean();
		for(int i=0;i<resultado.size();i++){
			dato = (W83bHistoricosBean)resultado.get(i);
			dato.setTerritorio(param.getTerritorio());
			dato.setDescTerritorio(param.getDescTerritorio());
			dato.setPorComarca(param.getPorComarca());
			dato.setMes(param.getMes());
			dato.setAnyo(param.getAnyo());
		}
		
		return resultado;
	}
	
	public List w83bCargaResultSexoHist(W83bHistoricosBean param) throws Exception {
		List resultado = new ArrayList();
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		
		strSql.append("SELECT ").append(W83bHistoricosBD.C_TERRIT_078).append(", NVL(SUM (").append(W83bHistoricosBD.T_ELECHH49_078);
		strSql.append("+").append(W83bHistoricosBD.T_ELECHM49_078).append("),'0') AS ELECH,");
		strSql.append(" NVL(SUM (").append(W83bHistoricosBD.T_ELECMH49_078).append("+").append(W83bHistoricosBD.T_ELECMM49_078).append("),'0') AS ELECM,");
		strSql.append(" NVL(SUM (").append(W83bHistoricosBD.T_ELECNH49_078).append("+").append(W83bHistoricosBD.T_ELECNM49_078).append("),'0') AS ELECN, ");
		strSql.append(" NVL(SUM(").append(W83bHistoricosBD.T_ELECHH49_078).append("+").append(W83bHistoricosBD.T_ELECHM49_078);
		strSql.append("+").append(W83bHistoricosBD.T_ELECMH49_078).append("+").append(W83bHistoricosBD.T_ELECMM49_078);
		strSql.append("+").append(W83bHistoricosBD.T_ELECNH49_078).append("+").append(W83bHistoricosBD.T_ELECNM49_078);
		strSql.append("),'0') AS TOTELECTORES,");
		strSql.append(" NVL(SUM (").append(W83bHistoricosBD.T_TRABH_078).append("),'0') AS TRABH,").append(" NVL(SUM (");
		strSql.append(W83bHistoricosBD.T_TRABM_078).append("),'0') AS TRABM,  NVL(SUM (").append(W83bHistoricosBD.T_TRABN_078).append("),'0') AS TRABN,");		
		strSql.append(" NVL(SUM (").append(W83bHistoricosBD.T_TRABH_078).append("+");
		strSql.append(W83bHistoricosBD.T_TRABM_078).append("+").append(W83bHistoricosBD.T_TRABN_078).append("),'0') AS TOTTRABAJADORES,");		
		strSql.append("  NVL(SUM (").append(W83bHistoricosBD.T_CANDH_078).append("),'0') AS CANDH,");
		strSql.append(" NVL(SUM (").append(W83bHistoricosBD.T_CANDM_078).append("),'0') AS CANDM,");
		strSql.append("  NVL(SUM (").append(W83bHistoricosBD.T_CANDH_078).append("+");
		strSql.append(W83bHistoricosBD.T_CANDM_078).append("),'0') AS TOTCANDIDATOS ");
		strSql.append(" FROM ").append(W83bHistoricosBD.tabla78);
		strSql.append(" WHERE ").append(W83bHistoricosBD.ANO_RES_078).append("=").append(param.getAnyo());
		strSql.append(" AND ").append(W83bHistoricosBD.MES_RES_078).append("=").append(param.getMes());
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_078).append("=").append(param.getTerritorio());
		}
		strSql.append(" GROUP BY ").append(W83bHistoricosBD.C_TERRIT_078);
		
		resultado =  W83bDataBase.executeQuery(strSql.toString(),resultado,W83bHistoricosBean.class,param.getUsuarioBean(), null);
		
		W83bHistoricosBean dato = new W83bHistoricosBean();
		for(int i=0;i<resultado.size();i++){
			dato = (W83bHistoricosBean)resultado.get(i);
			dato.setTerritorio(param.getTerritorio());
			if("48".equals(dato.getTerritorio78())){
				dato.setDescTerritorio("Bizkaia");
			}else if("20".equals(dato.getTerritorio78())){
				dato.setDescTerritorio("Gipuzkoa");
			}else{
				dato.setDescTerritorio("Araba/lava");
			}
			dato.setMes(param.getMes());
			dato.setAnyo(param.getAnyo());
			
			strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
			strSql.append("SELECT ").append(W83bHistoricosBD.C_TERRIT_077).append(",");
			strSql.append(" NVL(SUM(").append(W83bHistoricosBD.N_DELH_077).append("),'0') AS DELH,  NVL(SUM(");
			strSql.append(W83bHistoricosBD.N_DELM_077).append("),'0') AS DELM, ");
			strSql.append(" NVL(SUM(").append(W83bHistoricosBD.N_DELH_077).append("+");
			strSql.append(W83bHistoricosBD.N_DELM_077).append("),'0') AS TOTDEL ");
			strSql.append(" FROM ").append(W83bHistoricosBD.tabla77);
			strSql.append(" WHERE ").append(W83bHistoricosBD.ANO_RES_077).append("=");
			strSql.append(param.getAnyo()).append(" AND ").append(W83bHistoricosBD.MES_RES_077).append("=").append(param.getMes());
			strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_077).append("='").append(dato.getTerritorio78());
			strSql.append("' GROUP BY ").append(W83bHistoricosBD.C_TERRIT_077);
			List params= new ArrayList();//NOPMD
			List resultado2 =  W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);
			W83bHistoricosBean dato2 = (W83bHistoricosBean)resultado2.get(0);
			
			dato.setDelegadosH(dato2.getDelegadosH());
			dato.setDelegadosM(dato2.getDelegadosM());
			dato.setTotDel(dato2.getTotalDelegados());
		}
		
		return resultado;
	}
	
	
	public List w83bCargaDelegConvenioHist(W83bHistoricosBean param) throws Exception {
		List resultado = new ArrayList();
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		strSql.append("SELECT ").append(W83bHistoricosBD.C_SECTOR_080).append(",").append(W83bHistoricosBD.C_CONV_080).append(",");
		strSql.append(W83bHistoricosBD.C_SINDI_080).append(", SUM(").append(W83bHistoricosBD.T_DELEG_080).append(") AS TOTALDELEG, SUM(");
		strSql.append(W83bHistoricosBD.T_CENTROS_079).append(") AS TOTCENTROS , SUM(").append(W83bHistoricosBD.T_TRABA_079);
		strSql.append(") AS TOTTRABAJADORES,SUM(").append(W83bHistoricosBD.T_ELECT_079).append(") AS TOTELECTORES,");
		strSql.append("SUM(").append(W83bHistoricosBD.T_VOTA_079).append(") AS TOTVOTANTES,").append(W83bHistoricosBD.SIGLAS_019);
		strSql.append(",").append(W83bHistoricosBD.DESC_004).append(" AS SECTOR , ");
		
		if("es".equals(param.getIdioma())){
			strSql.append(W83bHistoricosBD.DESC_013).append(" AS CONV ");
		}else{
			strSql.append(W83bHistoricosBD.DESE_013).append(" AS CONV ");
		}
		strSql.append(" FROM ").append(W83bHistoricosBD.tabla79).append(",").append(W83bHistoricosBD.tabla80).append(",");
		strSql.append(W83bHistoricosBD.tabla19).append(",").append(W83bHistoricosBD.tabla04).append(",").append(W83bHistoricosBD.tabla13);
		strSql.append(" WHERE ").append(W83bHistoricosBD.ANO_RES_080).append("=").append(param.getAnyo());
		strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_079).append("=").append(param.getAnyo());
		strSql.append(" AND ").append(W83bHistoricosBD.MES_RES_080).append("=").append(param.getMes());
		strSql.append(" AND ").append(W83bHistoricosBD.MES_RES_079).append("=").append(param.getMes());
  
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_080).append("=").append(param.getTerritorio());
			strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_079).append("=").append(param.getTerritorio());
		}
		strSql.append(" AND ").append(W83bHistoricosBD.C_SECTOR_079).append("=").append(W83bHistoricosBD.C_SECTOR_080);
		strSql.append(" AND ").append(W83bHistoricosBD.C_CONV_079).append("=").append(W83bHistoricosBD.C_CONV_080);
		strSql.append(" AND ").append(W83bHistoricosBD.C_SINDI_080).append("=").append(W83bHistoricosBD.C_SINDI_019);
		strSql.append(" AND ").append(W83bHistoricosBD.C_SECTOR_079).append("=").append(W83bHistoricosBD.SECC_004);
		strSql.append(" AND ").append(W83bHistoricosBD.C_CONV_079).append("=").append(W83bHistoricosBD.C_CONV_013);
  
		if (param.getSector()!=null&&!"null".equals(param.getSector())&&!"".equals(param.getSector())){
			strSql.append(" AND ").append(W83bHistoricosBD.SECC_004).append("='").append(param.getSector()).append("' ");
		}
		
		if (param.getConvenio()!=null&&!"null".equals(param.getConvenio())&&!"".equals(param.getConvenio())){
			strSql.append(" AND ").append(W83bHistoricosBD.C_CONV_079).append("=").append(param.getConvenio());
		}
		strSql.append(" GROUP BY ").append(W83bHistoricosBD.C_SECTOR_080).append(",").append(W83bHistoricosBD.C_CONV_080);
		strSql.append(" , ").append(W83bHistoricosBD.C_SINDI_080).append(",").append(W83bHistoricosBD.SIGLAS_019);
		strSql.append(" , ").append(W83bHistoricosBD.DESC_004).append(",");
		
		if("es".equals(param.getIdioma())){
			strSql.append(W83bHistoricosBD.DESC_013);
		}else{
			strSql.append(W83bHistoricosBD.DESE_013);
		}
	
		strSql.append(" ORDER BY ").append(W83bHistoricosBD.C_SECTOR_080).append(",").append(W83bHistoricosBD.C_CONV_080);
		strSql.append(" , ").append("TOTALDELEG DESC");

		resultado =  W83bDataBase.executeQuery(strSql.toString(),resultado,W83bHistoricosBean.class,param.getUsuarioBean(), null);
		
		for(int i=0;i<resultado.size();i++){
			W83bHistoricosBean dato = (W83bHistoricosBean)resultado.get(i);
			dato.setDescTerritorio(param.getDescTerritorio());
			dato.setTerritorio(param.getTerritorio());
			dato.setAnyo(param.getAnyo());
			dato.setMes(param.getMes());
		}

		strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		strSql.append("SELECT ").append(W83bHistoricosBD.C_SECTOR_080).append(",");
		strSql.append(W83bHistoricosBD.C_SINDI_080).append(", SUM(").append(W83bHistoricosBD.T_DELEG_080);
		strSql.append(") AS TOTALDELEG, SUM(");
		strSql.append(W83bHistoricosBD.T_CENTROS_079).append(") AS TOTCENTROS , SUM(").append(W83bHistoricosBD.T_TRABA_079);
		strSql.append(") AS TOTTRABAJADORES,SUM(").append(W83bHistoricosBD.T_ELECT_079).append(") AS TOTELECTORES,");
		strSql.append("SUM(").append(W83bHistoricosBD.T_VOTA_079).append(") AS TOTVOTANTES,").append(W83bHistoricosBD.SIGLAS_019);
		strSql.append(" FROM ").append(W83bHistoricosBD.tabla79).append(",");
		strSql.append(W83bHistoricosBD.tabla80).append(",").append(W83bHistoricosBD.tabla19).append(",");
		strSql.append(W83bHistoricosBD.tabla04).append(",").append(W83bHistoricosBD.tabla13);
		strSql.append(" WHERE ").append(W83bHistoricosBD.ANO_RES_080).append("=").append(param.getAnyo());
		strSql.append(" AND ").append(W83bHistoricosBD.ANO_RES_079).append("=").append(param.getAnyo());
		strSql.append(" AND ").append(W83bHistoricosBD.MES_RES_079).append("=").append(param.getMes());
		strSql.append(" AND ").append(W83bHistoricosBD.MES_RES_080).append("=").append(param.getMes());
  
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio()))
		{
			strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_080).append("=").append(param.getTerritorio());
			strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_079).append("=").append(param.getTerritorio());
		}
		strSql.append(" AND ").append(W83bHistoricosBD.C_SECTOR_079).append("=").append(W83bHistoricosBD.C_SECTOR_080);
		strSql.append(" AND ").append(W83bHistoricosBD.C_CONV_079).append("=").append(W83bHistoricosBD.C_CONV_080);
		strSql.append(" AND ").append(W83bHistoricosBD.C_CONV_079).append("=").append(W83bHistoricosBD.C_CONV_013);
		strSql.append(" AND ").append(W83bHistoricosBD.C_SINDI_080).append("=").append(W83bHistoricosBD.C_SINDI_019);
		strSql.append(" AND ").append(W83bHistoricosBD.C_SECTOR_079).append("=").append(W83bHistoricosBD.SECC_004);
		  
		if (param.getSector()!=null&&!"null".equals(param.getSector())&&!"".equals(param.getSector())){
			strSql.append(" AND ").append(W83bHistoricosBD.SECC_004).append("='").append(param.getSector()).append("' ");
		}
		
		if (param.getConvenio()!=null&&!"null".equals(param.getConvenio())&&!"".equals(param.getConvenio())){
			strSql.append(" AND ").append(W83bHistoricosBD.C_CONV_079).append("=").append(param.getConvenio());
		}
		strSql.append(" GROUP BY ").append(W83bHistoricosBD.C_SECTOR_080);
		strSql.append(" , ").append(W83bHistoricosBD.C_SINDI_080).append(",").append(W83bHistoricosBD.SIGLAS_019);
		
		strSql.append(" ORDER BY ").append(W83bHistoricosBD.C_SECTOR_080);
		strSql.append(" , TOTALDELEG DESC");
		List params = new ArrayList(); 
		List resultado2 =  W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);
		
		if(resultado2.size()>0){
			resultado.add(resultado2);
		}
		
		strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		strSql.append(" SELECT   ").append(W83bHistoricosBD.C_SECTOR_080).append(",");
		strSql.append(W83bHistoricosBD.C_CONV_080).append(",SUM (");
		strSql.append(W83bHistoricosBD.T_DELEG_080).append(" ) AS totaldeleg FROM ");
		strSql.append(W83bHistoricosBD.tabla79).append(",");
		strSql.append(W83bHistoricosBD.tabla80).append(",");
		strSql.append(W83bHistoricosBD.tabla19).append(",");
		strSql.append(W83bHistoricosBD.tabla04).append(",");
		strSql.append(W83bHistoricosBD.tabla13).append(" WHERE ");
		strSql.append(W83bHistoricosBD.ANO_RES_080).append(" = ").append(param.getAnyo()).append(" AND ");
		strSql.append(W83bHistoricosBD.ANO_RES_079).append(" = ").append(param.getAnyo()).append(" AND ");
		strSql.append(W83bHistoricosBD.MES_RES_079).append(" = ").append(param.getMes()).append(" AND ");
		strSql.append(W83bHistoricosBD.MES_RES_080).append(" = ").append(param.getMes()).append(" AND ");
		strSql.append(W83bHistoricosBD.C_SECTOR_079).append(" = ").append(W83bHistoricosBD.C_SECTOR_080).append(" AND ");
		strSql.append(W83bHistoricosBD.C_CONV_079).append(" = ").append(W83bHistoricosBD.C_CONV_080).append(" AND ");
		strSql.append(W83bHistoricosBD.C_CONV_079).append(" = ").append(W83bHistoricosBD.C_CONV_013).append(" AND ");
		strSql.append(W83bHistoricosBD.C_SINDI_080).append(" = ").append(W83bHistoricosBD.C_SINDI_019).append(" AND ");
		strSql.append(W83bHistoricosBD.C_SECTOR_079).append(" = ").append(W83bHistoricosBD.SECC_004);
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio()))
		{
			strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_080).append("=").append(param.getTerritorio());
			strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_079).append("=").append(param.getTerritorio());
		}
		if (param.getSector()!=null&&!"null".equals(param.getSector())&&!"".equals(param.getSector())){
			strSql.append(" AND ").append(W83bHistoricosBD.SECC_004).append("='").append(param.getSector()).append("' ");
		}
		
		if (param.getConvenio()!=null&&!"null".equals(param.getConvenio())&&!"".equals(param.getConvenio())){
			strSql.append(" AND ").append(W83bHistoricosBD.C_CONV_079).append("=").append(param.getConvenio());
		}
		
		strSql.append(" GROUP BY ").append(W83bHistoricosBD.C_SECTOR_080).append(",").append(W83bHistoricosBD.C_CONV_080);
		strSql.append(" ORDER BY ").append(W83bHistoricosBD.C_SECTOR_080).append(",").append(W83bHistoricosBD.C_CONV_080);
		List resultado3 =  W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);
		HashMap mapa = new HashMap();
		for(int i=0;i<resultado3.size();i++){
			W83bHistoricosBean dato = (W83bHistoricosBean)resultado3.get(i);
			mapa.put(dato.getSector()+dato.getConvenio80(), dato.getTotDel());
		}
		
		if(resultado3.size()>0){
			resultado.add(mapa);
		}
		
		
		strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		strSql.append(" SELECT   ").append(W83bHistoricosBD.C_SINDI_080).append(",SUM(");
		strSql.append(W83bHistoricosBD.T_DELEG_080).append(") AS TOTALDELEG, ");
		strSql.append(" SUM(").append(W83bHistoricosBD.T_CENTROS_079);
		strSql.append(") AS TOTCENTROS , SUM(").append(W83bHistoricosBD.T_TRABA_079).append(") AS TOTTRABAJADORES,");
		strSql.append("SUM(").append(W83bHistoricosBD.T_ELECT_079).append(") AS TOTELECTORES,SUM(").append(W83bHistoricosBD.T_VOTA_079);
		strSql.append(") AS TOTVOTANTES,").append(W83bHistoricosBD.SIGLAS_019).append(" FROM ").append(W83bHistoricosBD.tabla79);
		strSql.append(",").append(W83bHistoricosBD.tabla80);
		strSql.append(",").append(W83bHistoricosBD.tabla19);
		strSql.append(",").append(W83bHistoricosBD.tabla04);
		strSql.append(",").append(W83bHistoricosBD.tabla13);
		strSql.append(" WHERE ");
		strSql.append(W83bHistoricosBD.ANO_RES_080).append(" = ").append(param.getAnyo()).append(" AND ");
		strSql.append(W83bHistoricosBD.ANO_RES_079).append(" = ").append(param.getAnyo()).append(" AND ");
		strSql.append(W83bHistoricosBD.MES_RES_079).append(" = ").append(param.getMes()).append(" AND ");
		strSql.append(W83bHistoricosBD.MES_RES_080).append(" = ").append(param.getMes()).append(" AND ");
		strSql.append(W83bHistoricosBD.C_SECTOR_079).append(" = ").append(W83bHistoricosBD.C_SECTOR_080).append(" AND ");
		strSql.append(W83bHistoricosBD.C_CONV_079).append(" = ").append(W83bHistoricosBD.C_CONV_080).append(" AND ");
		strSql.append(W83bHistoricosBD.C_CONV_079).append(" = ").append(W83bHistoricosBD.C_CONV_013).append(" AND ");
		strSql.append(W83bHistoricosBD.C_SINDI_080).append(" = ").append(W83bHistoricosBD.C_SINDI_019).append(" AND ");
		strSql.append(W83bHistoricosBD.C_SECTOR_079).append(" = ").append(W83bHistoricosBD.SECC_004);
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio()))
		{
			strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_080).append("=").append(param.getTerritorio());
			strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_079).append("=").append(param.getTerritorio());
		}
		if (param.getSector()!=null&&!"null".equals(param.getSector())&&!"".equals(param.getSector())){
			strSql.append(" AND ").append(W83bHistoricosBD.SECC_004).append("='").append(param.getSector()).append("' ");
		}
		
		if (param.getConvenio()!=null&&!"null".equals(param.getConvenio())&&!"".equals(param.getConvenio())){
			strSql.append(" AND ").append(W83bHistoricosBD.C_CONV_079).append("=").append(param.getConvenio());
		}
		strSql.append(" GROUP BY ").append(W83bHistoricosBD.C_SINDI_080).append(",").append(W83bHistoricosBD.SIGLAS_019);
		strSql.append(" ORDER BY TOTALDELEG DESC ");
		
		List resultado4 =  W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);
		if(resultado4.size()>0){
			resultado.add(resultado4);
		}
		return resultado;
		
	}
	
	
	public List w83bCargaDelegAgrupConvHist (W83bHistoricosBean param)throws Exception{
		List resultado = new ArrayList();
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		strSql.append("SELECT ").append(W83bHistoricosBD.C_AGRU_015).append(",").append(W83bHistoricosBD.C_CONV_080).append(",").append(W83bHistoricosBD.C_SINDI_080);
		if("es".equals(param.getIdioma())){
			strSql.append(",").append(W83bHistoricosBD.DESC_014).append(" AS AGRUP");
		}else {
			strSql.append(",").append(W83bHistoricosBD.DESE_014).append(" AS AGRUP");
		}
		if("es".equals(param.getIdioma())){
			strSql.append(",").append(W83bHistoricosBD.DESC_013).append(" AS CONV");
		}else{
			strSql.append(",").append(W83bHistoricosBD.DESE_013).append(" AS CONV");
		}
		strSql.append(",").append(W83bHistoricosBD.SIGLAS_019);
		if("es".equals(param.getIdioma())){
			strSql.append(",").append(W83bHistoricosBD.DESC_019).append(" AS SINDICATO");
		}else{
			strSql.append(",").append(W83bHistoricosBD.DESE_019).append(" AS SINDICATO");
		}
		strSql.append(",SUM (CASE  WHEN (").append(W83bHistoricosBD.C_TERRIT_080);
		strSql.append("= '01')  THEN ").append(W83bHistoricosBD.T_DELEG_080).append(" ELSE 0  END) AS ALAVA,");
		strSql.append(" SUM (CASE WHEN (").append(W83bHistoricosBD.C_TERRIT_080).append(" = '48') THEN ");
		strSql.append(W83bHistoricosBD.T_DELEG_080).append(" ELSE 0 END) AS BIZKAIA, SUM (CASE WHEN (");
		strSql.append(W83bHistoricosBD.C_TERRIT_080).append(" = '20') THEN ").append(W83bHistoricosBD.T_DELEG_080).append(" ELSE 0 END) AS GIPUZKOA");
		strSql.append(" FROM ").append(W83bHistoricosBD.tabla80).append(",").append(W83bHistoricosBD.tabla15).append(",").append(W83bHistoricosBD.tabla13);
		strSql.append(",").append(W83bHistoricosBD.tabla14).append(",").append(W83bHistoricosBD.tabla19);
		strSql.append(" WHERE ").append(W83bHistoricosBD.ANO_RES_080).append(" = ").append(param.getAnyo()).append(" AND ");
		strSql.append(W83bHistoricosBD.MES_RES_080).append(" = ").append(param.getMes()).append(" AND ").append(W83bHistoricosBD.C_CONV_080);
		strSql.append(" = ").append(W83bHistoricosBD.C_CONV_015).append(" AND ").append(W83bHistoricosBD.C_CONV_015).append(" = ");
		strSql.append(W83bHistoricosBD.C_CONV_013).append(" AND ").append(W83bHistoricosBD.C_AGRU_015).append(" = ");
		strSql.append(W83bHistoricosBD.C_AGRU_014);
		strSql.append(" AND ").append(W83bHistoricosBD.C_SINDI_080).append(" = ").append(W83bHistoricosBD.C_SINDI_019);
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_080).append(" = ").append(param.getTerritorio());
		}
		if (param.getAgrupacion()!=null&&!"null".equals(param.getAgrupacion())&&!"".equals(param.getAgrupacion())){
			strSql.append(" AND ").append(W83bHistoricosBD.C_AGRU_015).append(" = ").append(param.getAgrupacion());
		}
		strSql.append(" GROUP BY ").append(W83bHistoricosBD.C_AGRU_015).append(",").append(W83bHistoricosBD.C_CONV_080);
		strSql.append(",").append(W83bHistoricosBD.C_SINDI_080);
		
		if("es".equals(param.getIdioma())){
			strSql.append(",").append(W83bHistoricosBD.DESC_014);
		}else {
			strSql.append(",").append(W83bHistoricosBD.DESE_014);
		}
		if("es".equals(param.getIdioma())){
			strSql.append(",").append(W83bHistoricosBD.DESC_013);
		}else{
			strSql.append(",").append(W83bHistoricosBD.DESE_013);
		}
		strSql.append(",").append(W83bHistoricosBD.SIGLAS_019);
		if("es".equals(param.getIdioma())){
			strSql.append(",").append(W83bHistoricosBD.DESC_019);
		}else{
			strSql.append(",").append(W83bHistoricosBD.DESE_019);
		}
		strSql.append(" ORDER BY ").append(W83bHistoricosBD.C_AGRU_015).append(",").append(W83bHistoricosBD.C_CONV_080);
		strSql.append(",(ALAVA+ BIZKAIA+GIPUZKOA) DESC ");
		
		
		resultado =  W83bDataBase.executeQuery(strSql.toString(),resultado,W83bHistoricosBean.class,param.getUsuarioBean(), null);
		W83bHistoricosBean elDato = new W83bHistoricosBean();
		List params = new ArrayList();
		/*TOTAL DE CADA CONVENIO Y TERRITORIO*/
		for(int i=0;i<resultado.size();i++){
			elDato = (W83bHistoricosBean)resultado.get(i);
			
			strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
			strSql.append("SELECT ").append(W83bHistoricosBD.C_AGRU_015).append(",").append(W83bHistoricosBD.C_CONV_080);
			strSql.append(",SUM (CASE  WHEN (").append(W83bHistoricosBD.C_TERRIT_080);
			strSql.append("= '01')  THEN ").append(W83bHistoricosBD.T_DELEG_080).append(" ELSE 0  END) AS ALAVA,");
			strSql.append(" SUM (CASE WHEN (").append(W83bHistoricosBD.C_TERRIT_080).append(" = '48') THEN ");
			strSql.append(W83bHistoricosBD.T_DELEG_080).append(" ELSE 0 END) AS BIZKAIA, SUM (CASE WHEN (");
			strSql.append(W83bHistoricosBD.C_TERRIT_080).append(" = '20') THEN ").append(W83bHistoricosBD.T_DELEG_080);
			strSql.append(" ELSE 0 END) AS GIPUZKOA");
			strSql.append(" FROM ").append(W83bHistoricosBD.tabla80).append(",").append(W83bHistoricosBD.tabla15);
			strSql.append(",").append(W83bHistoricosBD.tabla13);
			strSql.append(",").append(W83bHistoricosBD.tabla14).append(",").append(W83bHistoricosBD.tabla19);
			strSql.append(" WHERE ").append(W83bHistoricosBD.ANO_RES_080).append(" = ").append(param.getAnyo()).append(" AND ");
			strSql.append(W83bHistoricosBD.MES_RES_080).append(" = ").append(param.getMes()).append(" AND ");
			strSql.append(W83bHistoricosBD.C_CONV_080);
			strSql.append(" = ").append(W83bHistoricosBD.C_CONV_015).append(" AND ").append(W83bHistoricosBD.C_CONV_015).append(" = ");
			strSql.append(W83bHistoricosBD.C_CONV_013).append(" AND ").append(W83bHistoricosBD.C_AGRU_015).append(" = ");
			strSql.append(W83bHistoricosBD.C_AGRU_014);
			strSql.append(" AND ").append(W83bHistoricosBD.C_SINDI_080).append(" = ").append(W83bHistoricosBD.C_SINDI_019);
			strSql.append(" AND ").append(W83bHistoricosBD.C_AGRU_015).append(" = ").append(elDato.getCodAgrupacion());
			strSql.append(" AND ").append(W83bHistoricosBD.C_CONV_080).append(" = ").append(elDato.getConvenio80());
			strSql.append(" AND ").append(W83bHistoricosBD.C_SINDI_080).append(" = ").append(W83bHistoricosBD.C_SINDI_019);
			if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
				strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_080).append(" = ").append(param.getTerritorio());
			}
			if (param.getAgrupacion()!=null&&!"null".equals(param.getAgrupacion())&&!"".equals(param.getAgrupacion())){
				strSql.append(" AND ").append(W83bHistoricosBD.C_AGRU_015).append(" = ").append(param.getAgrupacion());
			}
			strSql.append(" GROUP BY ").append(W83bHistoricosBD.C_AGRU_015).append(",").append(W83bHistoricosBD.C_CONV_080);			
			strSql.append(" ORDER BY ").append(W83bHistoricosBD.C_AGRU_015).append(",").append(W83bHistoricosBD.C_CONV_080);
			
			List resultado2 =  W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);
			if(resultado2.size()>0){
				W83bHistoricosBean elDato2 = (W83bHistoricosBean)resultado2.get(0);
				elDato.setTotalAlava(elDato2.getAlava());
				elDato.setTotalBizkaia(elDato2.getBizkaia());
				elDato.setTotalGipuzkoa(elDato2.getGipuzkoa());
				int totalCAV = (new Integer(elDato2.getAlava())).intValue()+(new Integer(elDato2.getBizkaia())).intValue()+(new Integer(elDato2.getGipuzkoa())).intValue();//NOPMD
				elDato.setTotalCAV(totalCAV+"");
				elDato.setDescTerritorio(param.getDescTerritorio());
				elDato.setTerritorio(param.getTerritorio());
				elDato.setMes(param.getMes());
				elDato.setAnyo(param.getAnyo());
			}
			
		}
		
		strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		strSql.append("SELECT ").append(W83bHistoricosBD.C_AGRU_015).append(",");
		strSql.append(W83bHistoricosBD.C_SINDI_080).append(",").append(W83bHistoricosBD.SIGLAS_019);
		if("es".equals(param.getIdioma())){
			strSql.append(",").append(W83bHistoricosBD.DESC_019).append(" AS SINDICATO");
		}else{
			strSql.append(",").append(W83bHistoricosBD.DESE_019).append(" AS SINDICATO");
		}
		strSql.append(",SUM (CASE  WHEN (").append(W83bHistoricosBD.C_TERRIT_080).append("= '01')  THEN ");
		strSql.append(W83bHistoricosBD.T_DELEG_080).append(" ELSE 0  END) AS ALAVA,");
		strSql.append(" SUM (CASE WHEN (").append(W83bHistoricosBD.C_TERRIT_080).append(" = '48') THEN ");
		strSql.append(W83bHistoricosBD.T_DELEG_080).append(" ELSE 0 END) AS BIZKAIA, SUM (CASE WHEN (");
		strSql.append(W83bHistoricosBD.C_TERRIT_080).append(" = '20') THEN ").append(W83bHistoricosBD.T_DELEG_080);
		strSql.append(" ELSE 0 END) AS GIPUZKOA");
		strSql.append(" FROM ").append(W83bHistoricosBD.tabla80).append(",").append(W83bHistoricosBD.tabla15).append(",");
		strSql.append(W83bHistoricosBD.tabla13);
		strSql.append(",").append(W83bHistoricosBD.tabla14).append(",").append(W83bHistoricosBD.tabla19);
		strSql.append(" WHERE ").append(W83bHistoricosBD.ANO_RES_080).append(" = ").append(param.getAnyo()).append(" AND ");
		strSql.append(W83bHistoricosBD.MES_RES_080).append(" = ").append(param.getMes());
		strSql.append(" AND ").append(W83bHistoricosBD.C_CONV_080);
		strSql.append(" = ").append(W83bHistoricosBD.C_CONV_015).append(" AND ").append(W83bHistoricosBD.C_CONV_015).append(" = ");
		strSql.append(W83bHistoricosBD.C_CONV_013).append(" AND ").append(W83bHistoricosBD.C_AGRU_015).append(" = ").append(W83bHistoricosBD.C_AGRU_014);
		strSql.append(" AND ").append(W83bHistoricosBD.C_SINDI_080).append(" = ").append(W83bHistoricosBD.C_SINDI_019);
		if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
			strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_080).append(" = ").append(param.getTerritorio());
		}
		if (param.getAgrupacion()!=null&&!"null".equals(param.getAgrupacion())&&!"".equals(param.getAgrupacion())){
			strSql.append(" AND ").append(W83bHistoricosBD.C_AGRU_015).append(" = ").append(param.getAgrupacion());
		}
		strSql.append(" GROUP BY ").append(W83bHistoricosBD.C_AGRU_015).append(",").append(W83bHistoricosBD.C_SINDI_080);
		strSql.append(",").append(W83bHistoricosBD.C_SINDI_080).append(",").append(W83bHistoricosBD.SIGLAS_019);
		if("es".equals(param.getIdioma())){
			strSql.append(",").append(W83bHistoricosBD.DESC_019);
		}else{
			strSql.append(",").append(W83bHistoricosBD.DESE_019);
		}
		strSql.append(",").append(W83bHistoricosBD.DESC_014).append(",").append(W83bHistoricosBD.DESE_014);
		strSql.append(" ORDER BY ").append(W83bHistoricosBD.C_AGRU_015);
		strSql.append(",(ALAVA+ BIZKAIA+GIPUZKOA) DESC ");
		
		List resultado3 =  W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);
		W83bHistoricosBean elDato2 = new W83bHistoricosBean();//NOPMD
		for(int i=0;i<resultado3.size();i++){
			elDato2 = (W83bHistoricosBean)resultado3.get(i);
			
			strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
			strSql.append("SELECT ").append(W83bHistoricosBD.C_AGRU_015).append(",SUM (CASE  WHEN (");
			strSql.append(W83bHistoricosBD.C_TERRIT_080).append("= '01')  THEN ").append(W83bHistoricosBD.T_DELEG_080).append(" ELSE 0  END) AS ALAVA,");
			strSql.append(" SUM (CASE WHEN (").append(W83bHistoricosBD.C_TERRIT_080).append(" = '48') THEN ");
			strSql.append(W83bHistoricosBD.T_DELEG_080).append(" ELSE 0 END) AS BIZKAIA, SUM (CASE WHEN (");
			strSql.append(W83bHistoricosBD.C_TERRIT_080).append(" = '20') THEN ").append(W83bHistoricosBD.T_DELEG_080);
			strSql.append(" ELSE 0 END) AS GIPUZKOA").append(" FROM ").append(W83bHistoricosBD.tabla80);
			strSql.append(",").append(W83bHistoricosBD.tabla15).append(",").append(W83bHistoricosBD.tabla13);
			strSql.append(",").append(W83bHistoricosBD.tabla14).append(",").append(W83bHistoricosBD.tabla19);
			strSql.append(" WHERE ").append(W83bHistoricosBD.ANO_RES_080).append(" = ").append(param.getAnyo()).append(" AND ");
			strSql.append(W83bHistoricosBD.MES_RES_080).append(" = ").append(param.getMes()).append(" AND ").append(W83bHistoricosBD.C_CONV_080);
			strSql.append(" = ").append(W83bHistoricosBD.C_CONV_015).append(" AND ").append(W83bHistoricosBD.C_CONV_015).append(" = ");
			strSql.append(W83bHistoricosBD.C_CONV_013).append(" AND ").append(W83bHistoricosBD.C_AGRU_015).append(" = ");
			strSql.append(W83bHistoricosBD.C_AGRU_014);
			strSql.append(" AND ").append(W83bHistoricosBD.C_AGRU_015).append(" = ").append(elDato2.getCodAgrupacion());
			strSql.append(" AND ").append(W83bHistoricosBD.C_SINDI_080).append(" = ").append(W83bHistoricosBD.C_SINDI_019);
			if (param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())&&!"".equals(param.getTerritorio())){
				strSql.append(" AND ").append(W83bHistoricosBD.C_TERRIT_080).append(" = ").append(param.getTerritorio());
			}
			if (param.getAgrupacion()!=null&&!"null".equals(param.getAgrupacion())&&!"".equals(param.getAgrupacion())){
				strSql.append(" AND ").append(W83bHistoricosBD.C_AGRU_015).append(" = ").append(param.getAgrupacion());
			}
			strSql.append(" GROUP BY ").append(W83bHistoricosBD.C_AGRU_015);			
			strSql.append(" ORDER BY ").append(W83bHistoricosBD.C_AGRU_015);
			
			List resultado4 =  W83bDataBase.executeQuery(strSql.toString(),params,W83bHistoricosBean.class,param.getUsuarioBean(), null);
			if(resultado4.size()>0){
				W83bHistoricosBean elDato3 = (W83bHistoricosBean)resultado4.get(0);
				elDato2.setTotalAlava(elDato3.getAlava());
				elDato2.setTotalBizkaia(elDato3.getBizkaia());
				elDato2.setTotalGipuzkoa(elDato3.getGipuzkoa());
				int totalCAV = (new Integer(elDato3.getAlava())).intValue()+(new Integer(elDato3.getBizkaia())).intValue()+(new Integer(elDato3.getGipuzkoa())).intValue();//NOPMD
				elDato2.setTotalCAV(totalCAV+"");
				elDato2.setDescTerritorio(param.getDescTerritorio());
				elDato2.setTerritorio(param.getTerritorio());
				elDato2.setMes(param.getMes());
				elDato2.setAnyo(param.getAnyo());
			}
			
		}
		if(resultado3.size()>0){
			resultado.add(resultado3);
		}
		return resultado;
	}
}
